/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 13.6)
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 *
 *  Kod testujcy uycie funkcji strtok i makeargv do rozbicia napisw 
 *  na sowa, rozdzielone biaymi znakami, jak rwnie samodzielne 
 *  rozbicie przy uyciu funkcji strchr, strspn i strpbrk.
 */

#include <stdio.h>
#include <string.h>
#ifdef mac
#include <console.h>
#endif

#ifdef __STDC__
extern int makeargv(char *, char *[], int);
#endif

main(argc, argv)
int argc;
char *argv[];
{
#ifdef publish
	char string[] = "to jest tylko test";	/* nie char * */
#else
	char string[100];
#endif
	char *p;

	char stringcopy[100];
	int l;

#ifdef mac
	console_options.nrows = 40;
     /*	argc = ccommand(&argv); */
#endif

	while(fgets(string, sizeof(string), stdin) != NULL)
	{
	printf("strtok:\n");

	strcpy(stringcopy, string);

	for(p = strtok(stringcopy, " \t\n"); p != NULL;
				p = strtok(NULL, " \t\n"))
		printf("\"%s\"\n", p);

	printf("makeargv:\n");

	strcpy(stringcopy, string);

	{
#ifdef publish
	char *av[10];
#else
	char *av[10+1];
#endif
	char dummy;
	av[10] = &dummy;
	{
	int i, ac = makeargv(stringcopy, av, 10);

	printf("(%d)\n", ac);
	for(i = 0; i < ac; i++)
		printf("\"%s\"\n", av[i]);
	if(ac < 10)
		printf("%p\n", av[ac]);
	if(av[10] != &dummy)
		printf("Bd: zakres tablicy av przekroczony\n");
	}
	}

	l = strlen(string);
	if(string[l-1] == '\n')
		string[l-1] = '\0';

	printf("ptla strchr:\n");

	strcpy(stringcopy, string);

	{

char *p = stringcopy;

while(1) {		/* wyjcie instrukcj break */
	char *p2 = strchr(p, '\t');
	if(p2 != NULL)
		*p2 = '\0';
	printf("\"%s\"\n", p);
	if(p2 == NULL)
		break;
	p = p2 + 1;
}
	}

	printf("ptla strpbrk:\n");

	strcpy(stringcopy, string);

	{
char *p = stringcopy;

/* nie radzi sobie z wieloma biaymi znakami (i napisami zoonymi tylko z biaych znakw) */

while(1) {	/* wyjcie instrukcj break */
	char *p2 = strpbrk(p, " \t\n");
	if(p2 != NULL)
		*p2 = '\0';
	printf("\"%s\"\n", p);
	if(p2 == NULL)
	break;
	p = p2 + 1;
}
	}

	printf("ptla strspn + strpbrk:\n");

	strcpy(stringcopy, string);

	{
char *p = stringcopy;

/* nie radzi sobie z biaymi znakami na kocu napisu (i napisami zoonymi tylko z biaych znakw)  */

while(1) {	/* wyjcie instrukcj break */
	char *p2;
	p += strspn(p, " \t\n");
	p2 = strpbrk(p, " \t\n");
	if(p2 != NULL)
		*p2 = '\0';
	printf("\"%s\"\n", p);
	if(p2 == NULL)
		break;
	p = p2 + 1;
}
	}
	}

	return 0;
}
